Dim DEBUG
DEBUG = False

Set FSO = CreateObject("Scripting.FileSystemObject")
Set WshShell = WScript.CreateObject("WScript.Shell")

'OldMailRoot  = input parameter
OldMailRoot =  WScript.Arguments(0)
DebugOutput(OldMailRoot)

'NewMailRoot = get_registry(HKLM\SOFTWARE\AfterLogic\XMail\MAIL_ROOT)
NewMailRoot = WshShell.RegRead("HKLM\SOFTWARE\AfterLogic\XMail\MAIL_ROOT")
DebugOutput(NewMailRoot)

' copy 'tab' file from root
CopyAllTabsExceptServer FSO.GetFolder(OldMailRoot), FSO.GetFolder(NewMailRoot)

Set OldDomainsFolder = FSO.GetFolder(FSO.BuildPath(OldMailRoot, "\domains"))
DebugOutput(OldDomainsFolder.Path)

'OldMailRoot\domains\*
'	for_each_domain from *dom
For Each OldDomainFolder in OldDomainsFolder.SubFolders

	' create domain folder if not exists
	If Not FSO.FolderExists(FSO.BuildPath(NewMailRoot, "\domains\" & OldDomainFolder.Name)) Then
		FSO.CreateFolder(FSO.BuildPath(NewMailRoot, "\domains\" & OldDomainFolder.Name))
	End If
	
	' copy all 'tab' files from domain folder
	If FileExistsExt(OldDomainFolder, "tab") Then
		FSO.CopyFile FSO.BuildPath(OldDomainFolder.Path, "*.tab"), FSO.BuildPath(NewMailRoot, "\domains\" & OldDomainFolder.Name)
	End If

'OldMailRoot\domains\*usr
'               for_each_mailbox from *usr
	For Each OldUserFolder in OldDomainFolder.SubFolders

		DebugOutput(OldUserFolder.Path)
		If FSO.FolderExists(FSO.BuildPath(OldUserFolder.Path, "\mailbox")) Then
			Set OldUserMailbox = FSO.GetFolder(FSO.BuildPath(OldUserFolder.Path, "\mailbox"))
			NewUserFolder = FSO.BuildPath(NewMailRoot, "\domains\" & OldDomainFolder.Name & "\" & OldUserFolder.Name)
			DebugOutput(OldUserMailbox.Path)
			DebugOutput(NewUserFolder)

			' create new user folder
			If Not FSO.FolderExists(NewUserFolder) Then
				FSO.CreateFolder(NewUserFolder)
			End If

			' copy all 'tab' files from domain folder
			If FileExistsExt(OldUserFolder, "tab") Then
				FSO.CopyFile FSO.BuildPath(OldUserFolder.Path, "*.tab"), NewUserFolder
			End If
			
			
			NewUserMailDir = FSO.BuildPath(NewMailRoot, "\domains\" & OldDomainFolder.Name & "\" & OldUserFolder.Name & "\Maildir")
			DebugOutput(NewUserMailDir)

'mkdir NewMailRoot\domains\*dom\*usr\Maildir
'mkdir NewMailRoot\domains\*dom\*usr\Maildir/new
'mkdir NewMailRoot\domains\*dom\*usr\Maildir/cur
'mkdir NewMailRoot\domains\*dom\*usr\Maildir/tmp
'cp/mv OldMailRoot\domains\*dom\*usr\mailbox\* NewMailRoot\domains\*dom\*usr\Maildir\new
			FSO.CreateFolder(NewUserMailDir)
			FSO.CreateFolder(NewUserMailDir & "\new")
			FSO.CreateFolder(NewUserMailDir & "\cur")
			FSO.CreateFolder(NewUserMailDir & "\tmp")
			FSO.CopyFile OldUserMailbox & "\*.*", NewUserMailDir & "\new\"

			CreateInfoTab NewUserMailDir
			
		End If
		
	Next

Next

DebugOutput("Done.")
WScript.Quit(0)



Sub DebugOutput(str)
	If DEBUG Then
		Set writeStream = FSO.OpenTextFile(Date & ".log", 8, True, -2)
		writeStream.WriteLine(str)
		writeStream.Close()
	End IF
	WScript.Echo str
End Sub

Function FileExistsExt(folder, extention)
	FileExistsExt = False
	For Each File in folder.Files
		If LCase(FSO.GetExtensionName(File)) = LCase(extention) Then
			FileExistsExt = True
			Exit For
		End If
	Next
End Function

Sub CopyAllTabsExceptServer(src, dest)
	For Each File in src.Files
		If LCase(FSO.GetExtensionName(File.Name)) = LCase("tab") Then
			If Not LCase(File.Name) = LCase("server.tab") Then
				FSO.CopyFile File.Path, dest.Path & "\"
				'DebugOutput "File path Src: " & File.Path
				'DebugOutput "File path Dest: " & dest.Path
			End If
		End If
	Next
End Sub

Sub CreateInfoTab(foldername)
	Dim InfoTabFile
	Set InfoTabFile = FSO.CreateTextFile(FSO.BuildPath(foldername, "info.tab"), True)
	InfoTabFile.WriteLine "IS.SUBSCRIBED 1"
	InfoTabFile.WriteLine "UIDVALIDITY " & DateDiff("s", DateSerial(1970, 1, 1), Now)
	InfoTabFile.WriteLine "UIDNEXT 1"
	InfoTabFile.Close
End Sub
